CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     init.f
C
C     This program creates the input file for the various versions of
C     the four-point stencil program.  It creates a 1,000 by 1,000 array
C     with random elements in the interior and a saddle shaped border
C     generated from a variation of the function f(x) = sin(x)/x.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      PROGRAM MAIN
      IMPLICIT NONE
      INTEGER prob_size
      PARAMETER (prob_size=1000)
      REAL pi
      INTEGER range, rand
      EXTERNAL rand
      PARAMETER (pi=3.1415926535, range=740)
      REAL stencil(0:prob_size-1, 0:prob_size-1)
      INTEGER i, j, k
      REAL f
      f(k) = (range * sin( k * 8.0 * pi / prob_size ) / k)

C					fill in the east & west borders
      DO i = 0, prob_size-1
	 stencil(i,0) = f(i + 1)
	 stencil(i,prob_size-1) = f(prob_size - i)
      END DO

C					fill in the north & south borders
      DO j = 0, prob_size-1
	 stencil(0,j) = f(j + 1)
         stencil(prob_size-1,j) = f(prob_size - j)
      END DO

C					fill in the middle of the array
      DO j = 1, prob_size-2
         DO i = 1, prob_size-2
	    stencil(i,j) = MOD(rand(), range)
         END DO
      END DO

C					write the array into a file
      OPEN(UNIT=1, FILE="stencil.dat", STATUS="NEW", ACTION="WRITE",
     1   ACCESS="DIRECT", FORM="UNFORMATTED", RECL=prob_size*4)
      DO j = 0, prob_size-1
         WRITE (1, REC=j+1) (stencil(i,j), i=0, prob_size-1)
      END DO
      CLOSE(UNIT=1)

      END
